/*------------------------------------------------------------------------------*
 * File Name:	Folder.h														*
 * Creation:	10/24/2001														*
 * Purpose: Origin C header	for Project Explorer - related classes and other	*
 *			related functions													*
 * Copyright (c) OriginLab Corp.2001											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 12/16/2004 UNIFIED_GRID_CONTEXT_MENU_HANDLING							*
 *------------------------------------------------------------------------------*/

#ifndef __FOLDER_H__
#define __FOLDER_H__

#include <common.h> // must always include this, has printf etc
#include <string.h> // most likely you will also need strings
#include <OC_const.h> // consts used in Origin internal functions
#include <stdio.h>	// stdio function like printf
#include <wksheet.h> // graph, plot and graphic objects
#include <Page.h> // page related classes
#include <Collection.h> //Contains declaration of the template class Collection
#include <OrgObj.h>

////////////////////////////////////////////////////////////////////////////////////

// Comments last updated by GRD on 1/27/2005
/**+
http://ocwiki.originlab.com/index.php?title=Category:Folder_(class)
*/
class Folder
{
public:


	// Comments last updated by GRD on 1/27/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-Folder
	*/
	Folder(); // Default folder constructor


	// Comments last updated by GRD on 1/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-Folder
	*/
	Folder(Folder &folder); // Folder Copy Constructor


	// Comments last updated by GRD on 1/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-Folder
	*/
	Folder(LPCSTR lpcszPathName); // Construct a folder using path


	// Comments last updated by GRD on 1/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-Activate
	*/
	BOOL Activate(); // Make a folder the active folder


	// Comments last updated by GRD on 1/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-GetName
	*/
	string GetName(); // Get the name of a folder


	// Comments last updated by GRD on 1/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-GetName
	*/
	BOOL GetName(string &strName); // Return the name of a folder to a string reference


	// Comments last updated by GRD on 1/25/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-Rename
	*/
	BOOL Rename(LPCSTR strName); // Rename a folder


	// Comments last updated by GRD on 1/27/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-GetPath
	*/
	string GetPath(); // Return full path of active folder as string


	// Comments last updated by GRD on 1/26/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-GetParent
	*/
	Folder GetParent(); // Get the parent folder of a folder object


	// Comments last updated by GRD on 1/27/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-GetFolder
	*/
	Folder	GetFolder(LPCSTR strPathName); // Return a folder object from its name


	// Comments last updated by GRD on 1/27/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-Move
	*/
	BOOL Move(LPCSTR lpcszItemName, LPCSTR lpcszPathName, BOOL bMoveFolder = false); // Move a folder or window


	// Comments last updated by GRD on 1/27/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-Attach
	*/
	Attach(LPCSTR lpcszPathName); // Attach or re-attach an existing folder object to a named instance


	// Comments last updated by GRD on 1/27/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-IsValid
	*/
	BOOL IsValid();	// Check if the folder object is valid


	// Comments last updated by GRD on 1/27/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-IsRootFolder
	*/
	BOOL IsRootFolder(); // Check if the folder object is the root folder.


	// Comments last updated by GRD on 2/16/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-RemoveSubFolder
	*/
	BOOL RemoveSubFolder(	LPCSTR lpcszSubFolderName,
							BOOL bFolderPrompt = FALSE,
							BOOL bPagePrompt = FALSE); // Delete a subfolder by name

	// Comments last updated by GRD on 1/31/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-AddSubfolder
	*/
	Folder AddSubfolder(LPCSTR lpcszSubFolderName); // Create a subfolder by name


	// Comments last updated by GRD on 2/18/2005
	/**$
		Remarks:
			Subfolders is a collection class of all folders below the specified object folder.
			You can access the collection in a foreach loop or get an individual folder by index.
			First folder has index of zero.
		Example1:
			// Get the name of the first subfolder of root
			void	Folder_Subfolders_Ex1()
			{
				Folder fld = Project.RootFolder;
				Folder subfld = fld.Subfolders(0); // The Subfolders collection is indexed from 0
				if(subfld.IsValid())
					out_str("The first subfolder is : " + subfld.GetName());
				else
					out_str("There are no subfolders");
			}
		Example2:
			// Output the names of all subfolders of root and the total count
			void	Folder_Subfolders_Ex2()
			{
				Folder	fld = Project.RootFolder;
				Folder	flds;
				uint	iCount = 0;
				foreach(flds in fld.Subfolders)
				{
					printf("%s\n", flds.GetName());
					iCount++;
				}
				if( iCount )
					printf("%u subfolders\n", iCount);
				else
					printf("There are no subfolders.\n");
			}
		Parameters:
			nIndex = [input] The index (from zero) of subfolders
		Return:
			Returns a folder object
	*/
	Folder Subfolders(int nIndex); // Get a subfolder by index


	// Comments last updated by GRD on 1/31/2005
	/**$
		Remarks:
			Get a subfolder by name.
		Example1:
			// Get a subfolder by name
			void	Folder_Subfolders_Ex3()
			{
				Folder fld = Project.RootFolder;
				Folder fldsub = fld.Subfolders("MyFolder");
				if( fldsub.IsValid() )
					printf("Found the subfolder of root named 'MyFolder'\n");
				else
					printf("No subfolder of root named 'MyFolder'\n");
			}
		Parameters:
			lpcszName = [input] The name of the folder
		Returns:
			Returns a folder object
	*/
	Folder Subfolders(LPCSTR lpcszName); // Get a subfolder by name


	// Comments last updated by GRD on 2/18/2005
	/**$
		Remarks:
			Get a page object from the Pages collection by index.  First page of the Pages collection has index of zero.
		Example1:
			// Get pages in the active folder using the Pages collection and index
			int	Folder_Pages_Ex1()
			{
				Folder	fld = Project.ActiveFolder();
				Page	pg;
				uint	iNumPages;
				uint	iIndex;
				string	strName;
			
				iNumPages = fld.Pages.Count();
				for( iIndex = 0 ; iIndex < iNumPages ; iIndex++)
				{
					pg = fld.Pages(iIndex);
					if( pg.IsValid() )
					{
						pg.GetName(strName);
						printf("Page is %s\n", strName);
					}
				}
				return (iNumPages);
			}
		Parameters:
			nIndex = [input] Zero-based index of the Pages collection
		Return:
			Returns the PageBase object identified by nIndex where nIndex is 0 based offset of order of creation.
	*/
	PageBase Pages(int nIndex); // Access a collection of pages by index
	/**$
	*/
	PageBase PagesAndShortcuts(int nIndex); // Access a collection of pages and shortcuts by index


	// Comments last updated by GRD on 2/18/2005
	/**$
		Remarks:
			Get a page object from the Pages collection by page name.
		Example1:
			// Get a page in the active folder using the Pages collection and a name
			void	Folder_Pages_Ex2(string	strName)
			{
				Folder	fld = Project.ActiveFolder();
				Page pg = fld.Pages(strName);
				if( pg )
					if( pg.GetShow() == PAGE_HIDDEN )
						printf("The page %s is hidden.\n", strName);
					else
						printf("The page %s is visible.\n", strName);
				else
					printf("Page %s not found in active folder\n", strName);
			}
		Parameters:
			lpcszName = [input] String name of page to attach to
		Return:
			Get a page by name.
	*/
	PageBase Pages(LPCSTR lpcszName); // Get a page object from the Pages collection by page name.
	/**$
	*/
	PageBase PagesAndShortcuts(LPCSTR lpcszName); // Get a page object from the Pages and Shortcts collection by page name.


	// Comments last updated by GRD on 2/18/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-Subfolders
	*/
	Collection<Folder> Subfolders; // Access subfolders as a collection


	// Comments last updated by GRD on 2/18/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-Pages
	*/
	Collection<PageBase> Pages; // Access Pages as a collection

	/**
	similar to the Pages collection, but also to include shortcuts. This is a new feature added in Origin 8.1
	*/
	Collection<PageBase> PagesAndShortcuts;

	/**$
		Remarks:
			Adds a shortcut to the given page to the Folder
		Parameters:
			page = [input] the page to which shortcut needs to be created
		Return:
			Returns FALSE if already present or invalid page. Otherwise non-zero
	*/
	BOOL AddShortcut(PageBase &page);
	/**$
		Remarks:
			Finds out if the Folder contains  a shortcut to the given page 
		Parameters:
			page = [input] the page for which to  find shortcut
		Return:
			Returns non-zero is present otherwise FALSE
	*/
	BOOL HasShortcut(PageBase &page);
	
#if  _OC_VER >= 0x0750
	// Comments last updated by GRD on 2/18/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Folder-SaveAsProject
	*/
	BOOL	SaveAsProject(LPCSTR lpcszPath, DWORD dwCntrl = SFC_INCLUDE_SUBFOLDERS); // Save a folder as an Origin project file
#endif //_OC_VER >= 0x0750

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetStorage
	*/
	storage		GetStorage(LPCSTR lpcszName, bool bAdd = FALSE); // Access storage areas.


	// Comments last updated by GRD on 2005.05.16
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetStorageNames
	*/
	BOOL 		GetStorageNames(vector<string> &vsNamesn, int nType = STORAGE_TYPE_ALL); // Get names of storage class objects

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetMemory
	*/
	BOOL GetMemory(LPCSTR lpcszName, vector<byte>& vb); // Get named binary storage into vector of bytes


	// Comments last updated by GJL on 04/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-SetMemory
	*/
	BOOL	SetMemory(LPCSTR lpcszName, vector<byte>& vb); // Set/Create named binary storage

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetBinaryStorage
	*/
	BOOL	GetBinaryStorage(LPCSTR lpcszName, TreeNode &tn);

// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-PutBinaryStorage
	*/
	BOOL	PutBinaryStorage(LPCSTR lpcszName, const TreeNode &tn);

};	// End of Folder class




#if  _OC_VER >= 0x0800
/// ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
#ifdef		__OC_GRID_RLOG
/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
/**#
*/
class	ResultsLog : public OriginObject
{
public:
	ResultsLog();

public:
	/// TD 8-30-04 QA70-6853  GRID_IN_OC
	///**#
	//*/
	//int		Find(TreeNode &treeQuery, TreeNode &treeResult, TreeNode &treeOtherItems = NULL);
	///**#
	//*/
	//BOOL	Expand(BOOL bExpand);
	//
	///**#
	//*/
	//int		BuildQueryTree(TreeNode &treeQuery);
	/// end  GRID_IN_OC
};	// End of ResultsLog class

/// ML 9/19/2005 QA70-8118 REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG
#endif		// __OC_GRID_RLOG
/// end REMOVING_RESULTS_LOG_AS_GRID_AND_RESTORING_THE_OLD_LOG

/// ML 12/16/2004 UNIFIED_GRID_CONTEXT_MENU_HANDLING
/// end UNIFIED_GRID_CONTEXT_MENU_HANDLING


#endif //_OC_VER >= 0x0800



#endif // __FOLDER_H__
